CREATE OR REPLACE FORCE VIEW w83b.w83bdelegagrupconv (codagrup,
                                                      descagrup,
                                                      deseagrup,
                                                      codconvenio,
                                                      descconvenio,
                                                      deseconvenio,
                                                      codsindicato,
                                                      sinddesc,
                                                      sinddese,
                                                      nacta,
                                                      anoacta,
                                                      territ,
                                                      ver,
                                                      felec,
                                                      fecharegistro,
                                                      fechabaja,
                                                      numdelegados
                                                     )
AS
   SELECT   consulta.codagrup, consulta.descagrup, consulta.deseagrup,
            consulta.codconvenio, consulta.descconvenio,
            consulta.deseconvenio, consulta.codsindicato, consulta.sinddesc,
            consulta.sinddese, consulta.nacta, consulta.anoacta,
            consulta.territ, consulta.ver, consulta.felec,
            consulta.fecharegistro, consulta.fechabaja, consulta.numdelegados
       FROM (SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (escrutinios.n_delm_024
                                + escrutinios.n_delh_024
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b24s00 escrutinios,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = escrutinios.n_acta_024
                  AND actas.ano_acta_016 = escrutinios.ano_acta_024
                  AND actas.c_territ_016 = escrutinios.c_territ_024
                  AND actas.version_016 = escrutinios.version_024
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND escrutinios.c_sindi_024 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016
             UNION ALL
             SELECT   agrupaciones.c_agru_014 AS codagrup,
                      agrupaciones.desc_014 AS descagrup,
                      agrupaciones.dese_014 AS deseagrup,
                      convenios.c_conv_013 AS codconvenio,
                      convenios.desc_013 AS descconvenio,
                      convenios.dese_013 AS deseconvenio,
                      sindicatos.c_sindi_019 AS codsindicato,
                      sindicatos.desc_019 AS sinddesc,
                      sindicatos.dese_019 AS sinddese,
                      actas.n_acta_016 AS nacta,
                      actas.ano_acta_016 AS anoacta,
                      actas.c_territ_016 AS territ, actas.version_016 AS ver,
                      actas.f_elecc_016 AS felec,
                      actas.fregdef_016 AS fecharegistro,
                      actas.f_baja_016 AS fechabaja,
                      NVL (SUM (diferencias.n_delm_018
                                + diferencias.n_delh_018
                               ),
                           '0'
                          ) AS numdelegados
                 FROM w83b16s00 actas,
                      w83b18s00 diferencias,
                      w83b13s00 convenios,
                      w83b19s00 sindicatos,
                      w83b15s00 convagrup,
                      w83b14s00 agrupaciones
                WHERE actas.n_acta_016 = diferencias.n_acta_018
                  AND actas.ano_acta_016 = diferencias.ano_acta_018
                  AND actas.c_territ_016 = diferencias.c_territ_018
                  AND actas.version_016 = diferencias.version_018
                  AND actas.c_conv_016 = convenios.c_conv_013
                  AND diferencias.c_sindi_018 = sindicatos.c_sindi_019(+)
                  AND convenios.c_conv_013 = convagrup.c_conv_015
                  AND convagrup.c_agru_015 = agrupaciones.c_agru_014(+)
                  AND actas.n_acttot_016 IS NULL
                  AND actas.validada_016 = 1
                  AND actas.n_regdef_016 IS NOT NULL
                  AND actas.f_baja_016 IS NULL
             GROUP BY agrupaciones.c_agru_014,
                      agrupaciones.desc_014,
                      agrupaciones.dese_014,
                      convenios.c_conv_013,
                      convenios.desc_013,
                      convenios.dese_013,
                      sindicatos.c_sindi_019,
                      sindicatos.desc_019,
                      sindicatos.dese_019,
                      actas.n_acta_016,
                      actas.ano_acta_016,
                      actas.c_territ_016,
                      actas.version_016,
                      actas.f_elecc_016,
                      actas.fregdef_016,
                      actas.f_baja_016) consulta
      WHERE consulta.ver =
               (SELECT MAX (version_016)
                  FROM w83b16s00 act
                 WHERE consulta.nacta = act.n_acta_016
                   AND consulta.anoacta = act.ano_acta_016
                   AND consulta.territ = c_territ_016
                   AND act.validada_016 = 1)
   ORDER BY consulta.codagrup, consulta.codconvenio, consulta.codsindicato;
/
/*******************************************************************************************************************************************************/ 
CREATE OR REPLACE FORCE VIEW w83b.w83bcentrotrabajo (codcentro,
                                                     cifnif,
                                                     tipcifnif,
                                                     ncentrotrabajo,
                                                     razonsocial,
                                                     razonsocialscaracteres,
                                                     domicilio,
                                                     municipio,
                                                     territorio,
                                                     territorio_eusk,
                                                     localidad,
                                                     codterritorio,
                                                     codmunicipio,
                                                     codpostal,
                                                     cnae,
                                                     num_trabajadores,
                                                     bajacentro,
                                                     telefono,
                                                     fax,
                                                     email
                                                    )
AS
   SELECT t73_01.ccen_001, t73_01.ccif_001, t73_01.tcif_001, t73_01.ncen_001,
          t73_01.rsoc_001, t73_01.rsos_001, t73_01.domic_001, fca02.ds_o,
          fca01.ds_o, fca01.ds_o, t73_01.local_001, t73_01.provc_001,
          t73_01.munic_001, t73_01.cposc_001, t73_01.cnae_001,
          t73_01.ntra_001, t73_01.baja_001, t73_01.tlf_001, t73_01.fax_001,
          t73_01.email_001
     FROM w83b.j7301s01 t73_01,
          t17i.t17_municipio fca02,
          t17i.t17_provincia fca01
    WHERE t73_01.provc_001 = fca02.provincia_id
      AND t73_01.munic_001 = fca02.ID
      AND fca02.provincia_id = fca01.ID
      AND t73_01.provc_001 = fca01.ID;
/
/*******************************************************************************************************************************************************/ 
ALTER TABLE w83b08t00
ADD ncen_008 number(3);
/
/*******************************************************************************************************************************************************/ 
CREATE OR REPLACE FORCE VIEW w83b.w83bdetallepreavpendtram (raz_social_008,
                                                            domic_008,
                                                            c_territ_008,
                                                            munic_008,
                                                            codpos_008,
                                                            telefono_008,
                                                            fax_008,
                                                            email_008,
                                                            cnae_008,
                                                            f_inicio_008,
                                                            c_conv_008,
                                                            s_parcial_008,
                                                            global_008,
                                                            admonemp_008,
                                                            n_cenafec_008,
                                                            c_sindi_prom_008,
                                                            ident_008,
                                                            observ_008,
                                                            estado_008,
                                                            preaviso_008,
                                                            f_entrada_007,
                                                            desccnae,
                                                            cif_008,
                                                            lote_008,
                                                            n_regis_008,
                                                            prov_008,
                                                            n_preavisos_007,
                                                            tipo_008,
                                                            n_preaviso_008,
                                                            ano_preaviso_008,
                                                            f_regis_008,
                                                            c_sindi_007,
                                                            correl_007,
                                                            f_creacion_007,
                                                            tipo_iden_008,
                                                            th_ss_008,
                                                            n_ss_008,
                                                            ctrl_ss_008,
                                                            n_trabaj_008,
                                                            ncen_008
                                                           )
AS
   SELECT raz_social_008, domic_008, c_territ_008, munic_008, codpos_008,
          telefono_008, fax_008, email_008, cnae_008, f_inicio_008,
          c_conv_008, s_parcial_008, global_008, admonemp_008, n_cenafec_008,
          c_sindi_prom_008, ident_008, observ_008, estado_008, preaviso_008,
          f_entrada_007, desccnae, cif_008, lote_008, n_regis_008, prov_008,
          n_preavisos_007, tipo_008, n_preaviso_008, ano_preaviso_008,
          f_regis_008, c_sindi_007, correl_007, f_creacion_007, tipo_iden_008,
          th_ss_008, n_ss_008, ctrl_ss_008, n_trabaj_008,ncen_008
     FROM w83b08s00 preavisos INNER JOIN w83b07s00 lotes
          ON preavisos.lote_008 = lotes.lote_007
          LEFT OUTER JOIN w83bcnae cnae ON preavisos.cnae_008 = cnae.idcnae
          ;
/
ALTER TABLE w83b42t00 ADD FECHA_CIERRE_01_042 DATE;
/
/*******************************************************************************************************************************************************/ 
ALTER TABLE w83b42t00 ADD FECHA_CIERRE_20_042 DATE;
/
/*******************************************************************************************************************************************************/ 
ALTER TABLE w83b42t00 ADD FECHA_CIERRE_48_042 DATE;
/
/*******************************************************************************************************************************************************/ 